/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: log.h,v 1.16.2.7 2003/09/16 19:40:28 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_LOG_H_INCLUDED
#define ZORP_LOG_H_INCLUDED

#include <zorp/zorplib.h>

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef ENABLE_TRACE
#if ZORPLIB_ENABLE_TRACE
  #define ENABLE_TRACE 1
#endif /* ZORPLIB_ENABLE_TRACE */
#endif /* ENABLE_TRACE */

LIBZORPLL_DLLIMPEX unsigned int verbose_level;
//extern LIBZORPLL_DLLIMPEX unsigned int debug_flag;
LIBZORPLL_DLLIMPEX gchar fake_session_id[256];

#define ZORP_SYSLOG_FACILITY LOG_LOCAL6

#define ZLF_SYSLOG      0x0001
#define ZLF_TAGS        0x0002
#define ZLF_THREAD      0x0004
#define ZLF_STDERR      0x0008

#ifndef G_OS_WIN32
  #define z_debug(level, format, args...)   z_llog("core.debug", level, format, ##args)
  #define z_warning(level, format, args...) z_llog("core.warning", level, format, ##args)
  #define z_message(level, format, args...) z_llog("core.message", level, format, ##args)
#else
  #define z_debug(level, format, args)   z_llog("core.debug", level, format, ##args)
  #define z_warning(level, format, args) z_llog("core.warning", level, format, ##args)
  #define z_message(level, format, args) z_llog("core.message", level, format, ##args)
#endif

void z_log_init(const gchar *ls, const gchar *syslog_name, guint flags);

void z_logv(gchar *class, int level, gchar *format, va_list ap);

#ifndef G_OS_WIN32
  void z_llog(gchar *class, int level, gchar *format, ...) __attribute__ ((format(printf, 3, 4)));
#else
  void z_llog(gchar *class, int level, gchar *format, ...);
#endif
int z_log_register_class(gchar *class);
gboolean z_log_enabled(gchar *class, int level);
void z_log_clear_hash(void);
void z_log_destroy(void);

const gchar *z_log_session_id(const gchar *session_id);

#ifdef G_OS_WIN32
  void z_log(gchar* session_id, gchar* class, int level, gchar* format, ...);
//  void z_proxy_log(ZProxy *self, gchar* class, int level, char* format, ...);
  #define z_proxy_log
#else
  #define z_log(session_id, class, level, format, args...) \
    do \
      { \
        z_llog(class, level, "(%s): " format, z_log_session_id(session_id) , ##args); \
      } \
    while (0)

  #define z_proxy_log(self, class, level, format, args...) \
	  z_log(((ZProxy *)self)->session_id, class, level, format,  ##args)
#endif

#if ENABLE_TRACE
  #ifndef G_OS_WIN32
    #define z_trace(session_id, args...) z_log(session_id , CORE_TRACE, 7, ##args)
  #else
    #define z_trace
  #endif
  #define z_enter() z_log(NULL, CORE_TRACE, 7, "Enter %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_leave() z_log(NULL, CORE_TRACE, 7, "Leave %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_cp() z_log(NULL, CORE_TRACE, 7, "Checkpoint %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_session_enter(s) z_log(s, CORE_TRACE, 7, "Enter %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_session_leave(s) z_log(s, CORE_TRACE, 7, "Leave %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_session_cp(s) z_log(s, CORE_TRACE, 7, "Checkpoint %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
#else
  #ifndef G_OS_WIN32
    #define z_trace(session_id, args...)
  #else
    #define z_trace
  #endif
  #define z_enter()
  #define z_leave()
  #define z_cp()
  #define z_session_enter(s)
  #define z_session_leave(s)
  #define z_session_cp(s)

#endif

#if ENABLE_TRACE
  #ifndef G_OS_WIN32
    #define z_proxy_trace(self, args...) z_proxy_log(self , CORE_TRACE, 7, ##args)
  #else
    #define z_proxy_trace
  #endif
  #define z_proxy_enter(self) z_proxy_log(self, CORE_TRACE, 7, "Enter %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_proxy_leave(self) z_proxy_log(self, CORE_TRACE, 7, "Leave %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
  #define z_proxy_cp(self) z_proxy_log(self, CORE_TRACE, 7, "Checkpoint %s (%s:%d)", __FUNCTION__, __FILE__, __LINE__)
#else
  #ifndef G_OS_WIN32
    #define z_proxy_trace(self, args...) 
  #else
    #define z_proxy_trace
  #endif
  #define z_proxy_enter(self)
  #define z_proxy_leave(self)
  #define z_proxy_cp(self)
#endif

#ifdef __cplusplus
}
#endif

#endif
